#include "apache.h"

char *get_tag(char *tag, int tagbuf_len)
{
  char *tag_val, c, term;
  char *t;

  t = tag;

  --tagbuf_len;

  do {
    GET_CHAR(c, NULL);
  } while (ap_isspace(c));

  if (c != '"' && c != '\'') {
    return NULL;
  }

  term = c;
  while (1) {
    GET_CHAR(c, NULL);
    if (t == tag + tagbuf_len) { /* Suppose t == tag + tagbuf_len - 1 */
      *t = EOS;
      return NULL;
    }  
    
    if (c == '\\') {
      GET_CHAR(c, NULL);
      if (c != term) {
        /* OK */
__TESTCLAIM_1:
        *t = '\\';
        t++;
        if (t == tag + tagbuf_len) {
          /* OK */
          *t = EOS;
          return NULL;
        }
      }
    }
    else if (c == term) {
      break;
    }

    /* OK */
    *t = c;
    t++;                /* Now t == tag + tagbuf_len + 1 
                         * So the bounds check (t == tag + tagbuf_len) will fail */
  }
  /* OK */
  *t = EOS;

  return tag;
}

int main ()
{
  char tag[MAX_STRING_LEN];

  /* The caller always passes in (tag, sizeof(tag)) */
  get_tag (tag, MAX_STRING_LEN);

  return 0;
}
