#include "constants.h"

extern int nondet_int();

void ftpls (char *line)
{
    int j;

    /* Stop at either:
     *  (1) first char before EOS which isn't in "-rwxdls", or,
     *  (2) first EOS
     */
    for(j = 0; line[j] != EOS; ++j)
      if (!strchr("-", line[j]))
        break;

    if(j == J && line[j] == ' ') {	/* long list */
      char user[USERSZ];
      /* OK */
      r_strncpy (user, line + j, USERSZ);
    }
}

int main ()
{
  char out [INSZ];
  int out_l;
  bool dirmode;
  static const char npf[] = NPF;
  const int npfsize = NPFSZ;
  int c;

  dirmode = false;

  out_l = 0;
  out[INSZ-1] = EOS;

 top:

  while((c = nondet_int()) != EOF) {
    if(c == '\r')
      c = '\n';
    if(c == '\n') {
      if(dirmode) {
        ftpls(out);
      } else {
        if(!out_l)
          continue;
        /* This assertion is meant to stop SatAbs from going insane 
         * and reporting a spurious error in strcmp. Which it still
         * does. :-/
         * 
         */
        assert (out_l <= INSZ-1);
        if (out_l > npfsize && !strcmp(out + out_l - npfsize, npf)) {
          dirmode = true;
          goto top;
        }
      }
      out_l = 0;
    } else {
      out_l++;
      if (out_l > INSZ-1)
        return ERR;
    }
  }

  return 0;
}
