#include "glob.h"

struct dirent {
  char    d_name[MAXNAMLEN + 1];
};

static int
g_Ctoc(Char *str, char *buf, size_t len)
{
	char *dc;

	if (len == 0)
		return 1;

	for (dc = buf; len && (*dc++ = *str++) != EOS; len--)
		continue;

	return len == 0;
}

static int
glob3(Char *pathbuf, Char *pathend, Char *pathlim, Char *pattern)
{
  struct dirent dp;
  int error;
  char buf[MAXPATHLEN];


  *pathend = EOS;
	    
  if (nondet_int()) {
    if (nondet_int()) {
      if (g_Ctoc(pathbuf, buf, sizeof(buf)))
        return (GLOB_ABORTED);
      if (nondet_int())
        return (GLOB_ABORTED);
    }
    
    if (nondet_int())
      return (GLOB_ABORTED);
    
    return(0);
  }
  
  error = 0;
  while (nondet_int()) {
    char *sc;
    Char *dc;

    /* Initial DOT must be matched literally. */
    if (dp.d_name[0] == DOT && *pattern != DOT)
      continue;
    /*
     * The resulting string contains EOS, so we can
     * use the pathlim character, if it is the nul
     */
    for (sc = dp.d_name, dc = pathend;;)
      if (dc > pathlim) break;
      else {
        *dc = *sc;
        dc++;
        sc++;
        /* OK */
        if (*dc == EOS) break;
      }
      
    
    /*
     * Have we filled the buffer without seeing EOS?
     */
    if (dc > pathlim && *pathlim != EOS) {
      /*
       * Abort when requested by caller, otherwise
       * reset pathend back to last SEP and continue
       * with next dir entry.
       */
      if (nondet_int()) {
        error = GLOB_ABORTED;
        break;
      }
      else {
        /* OK */
        *pathend = EOS;
        continue;
      }
    }

    /* match is scary */
    if (/*!match(pathend, pattern, restpattern)*/nondet_int()) {
      /* OK */
__TESTCLAIM_1:
      *pathend = EOS;
      continue;
    }/*
    error = glob2(pathbuf, --dc, pathlim, restpattern, pglob, limit);
    if (error)
    break;*/
  }

  return error;
}
int main ()
{
  Char *buf;
  Char *pattern;
  Char *bound;

  Char A [MAXPATHLEN+1];
  Char B [PATTERNLEN];

  buf = A;
  pattern = B;

  bound = A + sizeof(A)/sizeof(*A) - 1;

  glob3 (buf, buf, bound, pattern);

  return 0;
}
