#include "glob.h"

struct dirent {
  char    d_name[MAXNAMLEN + 1];
};

static int
g_Ctoc(Char *str, char *buf, size_t len)
{
  int i;

  if (len == 0)
    return 1;

  for (i = 0; len && (buf[i] = str[i]) != EOS; len--)
    i++;

  return len == 0;
}

static int
glob3(Char *pathbuf, Char *pathend, Char *pathlim, Char *pattern)
{
  struct dirent dp;
  int error;
  char buf[MAXPATHLEN];


  *pathend = EOS;
	    
  if (nondet_int()) {
    if (nondet_int()) {
      if (g_Ctoc(pathbuf, buf, sizeof(buf)))
        return (GLOB_ABORTED);
      if (nondet_int())
        return (GLOB_ABORTED);
    }
    
    if (nondet_int())
      return (GLOB_ABORTED);
    
    return(0);
  }
  
  error = 0;
  while (nondet_int()) {
    int i;

    /* Initial DOT must be matched literally. */
    if (dp.d_name[0] == DOT && *pattern != DOT)
      continue;
    /*
     * The resulting string contains EOS, so we can
     * use the pathlim character, if it is the nul
     */
    i = 0;
    for (;;)
      if (pathend + i > pathlim) break;
      else {
        pathend[i] = dp.d_name[i];
        i++;
        /* BAD */
        if (pathend[i] == EOS) break;
      }
          
    /*
     * Have we filled the buffer without seeing EOS?
     */
    if (pathend + i > pathlim && *pathlim != EOS) {
      /*
       * Abort when requested by caller, otherwise
       * reset pathend back to last SEP and continue
       * with next dir entry.
       */
      if (nondet_int()) {
        error = GLOB_ABORTED;
        break;
      }
      else {
        /* BAD */
        pathend[i] = EOS;
        continue;
      }
    }

    /* match() is scary, and recursive, which Satabs can't handle.
     * Replacing it with a non-deterministic stub....
     *
     * This is irrelevant to overflow detection anyhow, since this 
     * is *after* the overflow. */
    if (/*!match(pathend, pattern, restpattern)*/nondet_int()) {
      /* BAD */
__TESTCLAIM_1:
      pathend[i] = EOS;
      continue;
    }
  }

  return error;
}
int main ()
{
  Char *buf;
  Char *pattern;
  Char *bound;

  Char A [MAXPATHLEN+1];
  Char B [PATTERNLEN];

  buf = A;
  pattern = B;

  bound = A + sizeof(A) - 1;

  glob3 (buf, buf, bound, pattern);

  return 0;
}
