CPLUS = g++
SCOOT_HOME=$(HOME)/scoot
SCOOT_OPT+= -D __SCOOT__

# Cygwin users shall uncomment the next line
# CYGWIN = 1


#
# Original SystemC library (optional)
#

SYSTEMC_LIB=$(HOME)/systemc-2.2.0/lib-linux
SYSTEMC_INCLUDE=$(HOME)/systemc-2.2.0/include
TLM_INCLUDE=$(HOME)/TLM-2008-06-09/include/tlm

#
# Additional options for the race-Analysis examples
#

# Number of verification tasks that can be run in parallel.
ifndef JOBS
JOBS=2
endif

# Model-checker choice. Possible values are: smv, boom, boppo.
ifndef MODEL_CHECKER
MODEL_CHECKER=smv
endif

#
# Do not change the rest of this file unless you know what you are doing.
#

SCOOT_INCLUDE+= -I $(SCOOT_HOME)/include \
		-I $(SCOOT_HOME)/include/systemc \
		-I $(SCOOT_HOME)/include/stl \
		-I $(SCOOT_HOME)/include/tlm


SCOOT_LIB+= $(SCOOT_HOME)/include/systemc/libsystemc.cpp $(SCOOT_HOME)/include/stl/libstl.cpp


SCOOT=$(SCOOT_HOME)/bin/scoot
SCOOT_EXPLORER = $(SCOOT_HOME)/bin/scoot_explorer


ifdef CYGWIN
SCOOT+=.exe
SCOOT_EXPLORER+=.exe
endif


#
# Extract SystemC model and compile it into a "flat" C++ file
#
scoot_out.cpp: $(SRC)
	$(SCOOT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) $(SCOOT_OPT) $(INCLUDE) --cpp-out scoot_out.cpp

#
# Build the scoot simulator
#
scoot_sim: scoot_out.cpp
	$(CPLUS)  scoot_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_sim  -O2 -fno-strict-aliasing

#
# Build the original systemc simulator
#

ifdef USE_NONDET

systemc_sim: $(SRC)
	$(CPLUS) $(SRC) nondet.cpp $(INCLUDE) -I $(SYSTEMC_INCLUDE) -I $(TLM_INCLUDE) -I $(SCOOT_HOME)/include/tlm-ports -L $(SYSTEMC_LIB) -lsystemc -o systemc_sim -O2
else

systemc_sim: $(SRC)
	$(CPLUS) $(SRC) $(INCLUDE) -I $(SYSTEMC_INCLUDE) -I $(TLM_INCLUDE) -I $(SCOOT_HOME)/include/tlm-ports  -L $(SYSTEMC_LIB) -lsystemc -o systemc_sim -O2

endif

#
# Perform the race condition analysis
#
race_condition: $(SRC)
	$(SCOOT)  $(SCOOT_OPT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB)  --race-analysis --model-checker $(MODEL_CHECKER) --jobs $(JOBS)


#
#  Build the exhaustive simulator
#
scoot_exhaustive_out.cpp: $(SRC)
	$(SCOOT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) $(SCOOT_OPT) --cpp-out scoot_exhaustive_out.cpp --no-path-slicing --nondet-scheduler --jobs $(JOBS) --model-checker $(MODEL_CHECKER)

#
# Build the exhaustive simulators
#

scoot_exhaustive_sim.ps: scoot_exhaustive_out.cpp
	$(CPLUS) -fno-strict-aliasing  scoot_exhaustive_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_exhaustive_sim.ps -O2 -D PERSISTENT_SET -D SLEEP_SET

scoot_exhaustive_sim.s: scoot_exhaustive_out.cpp
	$(CPLUS)  -fno-strict-aliasing scoot_exhaustive_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_exhaustive_sim.s -O2  -D SLEEP_SET


scoot_exhaustive_sim.p: scoot_exhaustive_out.cpp
	$(CPLUS)  -fno-strict-aliasing scoot_exhaustive_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_exhaustive_sim.p -O2 -D PERSISTENT_SET


scoot_exhaustive_sim: scoot_exhaustive_out.cpp
	$(CPLUS)  -fno-strict-aliasing scoot_exhaustive_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_exhaustive_sim -O2 


scoot_random_sim: scoot_exhaustive_out.cpp
	$(CPLUS)  -fno-strict-aliasing scoot_exhaustive_out.cpp -I $(SCOOT_HOME)/include/bv -D __LITTLE_ENDIAN__ -o scoot_random_sim -O2  -D RANDOM_SEARCH

#
#  Show SystemC-model information:
#  - List of created signals.
#  - Port binding: port -> signal
#  - List of processes. For each process the following
#    information is outputed: the method that is called, the
#    module associated with the call, and the sensitivity list
#    of the process.
#    
show_model: $(SRC)
	$(SCOOT)  $(SCOOT_OPT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB)  --show-model
#
# Show the goto program of the function 'sc_main' after
# transformations.

show_main:
	$(SCOOT) $(SCOOT_OPT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) --show-goto-main

#
# In order to build an "executable" model, Scoot synthesizes
# a scheduler that is defined in the body of the function 'scoot_start'.
#

show_scheduler:
	$(SCOOT) $(SCOOT_OPT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) --show-scheduler


#
# Print all goto-functions.
# Note that 'sc_main' and 'scoot_sart' are also printed
#
show_goto_functions:
	$(SCOOT)  $(SCOOT_OPT) $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) --show-goto-functions

#
# Show symbol table
# Note that 'sc_main' and 'scoot_start' are also printed
#
show_symbol_table:
	$(SCOOT) $(SCOOT_OPT)  $(SRC) $(SCOOT_INCLUDE) $(SCOOT_LIB) --show-symbol-table


	
clean:
	rm -f scoot_sim
	rm -f systemc_sim
	rm -f scoot_out.cpp
	rm -f scoot_exhaustive_out.cpp
	rm -f scoot_exhaustive
	rm -f scoot_exhaustive.ps
	rm -f scoot_exhaustive.p
	rm -f *.exe
	rm -f *.vcd
	rm -f *.out
