#!/bin/bash
#
# Author: Blanc Nicolas
#
# Prupose:
# 
# Simple script to run the experiments. The
# only parameter of the script is the simulation
# time.
#
#

if [ ! $# == 1 ]; then
	echo "One parameter expected but got $#."
	exit
fi

echo $1 | grep "[^0-9]" > /dev/null 2>&1

if [ "$?" == "0" ]; then
	echo "Got \`$1' but expected a number."
	exit
fi

export SIM_TIME=$1

DIRECTORY="rc$SIM_TIME"
cp -r rc $DIRECTORY
cd $DIRECTORY
sed s/TIME/$1/ main.cpp.template > main.cpp
rm main.cpp.template
make all

echo "-- Persistent and sleep set" > time.log
(time scoot_explorer ./scoot_exhaustive_sim.ps 1000000) 2>> time.log
echo "" >> time.log
echo "-- Persistent set" >> time.log

(time scoot_explorer ./scoot_exhaustive_sim.p 1000000) 2>> time.log
echo "" >> time.log
echo "-- Sleep set" >> time.log

(time scoot_explorer ./scoot_exhaustive_sim.s 1000000) 2>> time.log
echo "" >> time.log
echo "--No partial order reduction" >> time.log
(time scoot_explorer ./scoot_exhaustive_sim 1000000) 2>> time.log

echo ""
echo "Statistics dumped in time.log"

echo ""
cat time.log
