#include <systemc.h>
#include "aes.h"
#include <iostream>

SC_MODULE(testing_module)
{
	sc_in<bool> clk;
	sc_inout<bool> rst;

	sc_inout<bool> load;
	sc_inout<bool> decrypt;
	sc_inout<sc_biguint<128> > data_o;
	sc_inout<sc_biguint<192> > key_o;


	sc_in<sc_biguint<128> > data_i;
	sc_in<bool > ready_i;
	
	void testing_process()
	{
		sc_biguint<128> data =  91666365;
		while(true)
		{
		
		rst = true;
		load = 0;
		decrypt = 0;
		data_o = 0;
		key_o = 0;
		wait();

		// encrypt
		load = true;
		data_o = data;
		key_o = 14249380;
		decrypt= 0;
		do
		{
			wait();
		} while(!clk.posedge());
		load = false;

		do
		{
			wait();	
		} while( ready_i.read() != true);

		sc_biguint<128> next_data = data_i;
		// decrypt
		load = true;
		data_o = data_i;
		decrypt = true;
		
		do
		{
			wait();
		} while(!clk.posedge());

		load = false;
		
		do
		{
			wait();
		} while( ready_i.read() != true);

		assert(data == data_i.read());
		data = next_data;

		#if 1
		std::cout
        << data.range(127,96) << "'" 
			  << data.range(95,64)  <<"'"
			  << data.range(63,32) <<"'"
			  << data.range(31,0) << std::endl;
		#endif

		}
		
	}

	SC_CTOR(testing_module)
	{
		SC_CTHREAD(testing_process, clk);
	}
	
	
};

int sc_main(int argc, char* argv[])
{
	sc_clock clk("clk");
	aes *ae1;

	ae1 = new aes("aes");

	sc_signal<bool> reset;
	sc_signal<bool> rt_load;
	sc_signal<bool> rt_decrypt;
	sc_signal<sc_biguint<128> > rt_data_i;
	sc_signal<sc_biguint<192> > rt_key;

	sc_signal<sc_biguint<128> > rt_data_o;
	sc_signal<bool>rt_ready;

	ae1->clk(clk);
	ae1->reset(reset);
	ae1->load_i(rt_load);
	ae1->decrypt_i(rt_decrypt);
	ae1->data_i(rt_data_i);
	ae1->key_i(rt_key);
	ae1->data_o(rt_data_o);
	ae1->ready_o(rt_ready);

	testing_module test_mod("tester");
	test_mod.clk(clk);
	test_mod.rst(reset);
	test_mod.load(rt_load);
	test_mod.decrypt(rt_decrypt);
	test_mod.data_o(rt_data_i);
	test_mod.key_o(rt_key);
	test_mod.data_i(rt_data_o);
	test_mod.ready_i(rt_ready);

#if 0
	sc_trace_file* ptf = sc_create_vcd_trace_file("aes");
	sc_trace<bool>(ptf, clk,"clk");
	sc_trace<bool>(ptf,reset,"rst");
        sc_trace<sc_biguint<128> >(ptf,ae1->addroundkey_data_o, "addroundkey_data_o");
	sc_trace<bool>(ptf,rt_load,"load");
	sc_trace<bool>(ptf,rt_decrypt, "decrypt");
	sc_trace<sc_biguint<128> >(ptf,rt_data_i, "data_i");
	sc_trace<sc_biguint<128> >(ptf,rt_key, "key");
	sc_trace<sc_biguint<128> >(ptf,rt_data_o, "data_o");
	sc_trace<bool>(ptf,rt_ready,"ready");
#endif
	sc_start(5000, SC_US);
#if 0
	sc_close_vcd_trace_file(ptf);
#endif
	return 0;
}
