#include <systemc.h>
#include "byte_mixcolum.h"

SC_MODULE(testert)
{
	sc_out<sc_uint<8> > a, b, c, d;
	sc_in<sc_uint<8> > inx, iny;
	
	sc_in<bool> clk;

	void test()
	{
		while(true)
		{
			a.write(85); b.write(126); c.write(51); d.write(201);
			wait();
			assert(inx.read() == 210);
			assert(iny.read() == 131);
			
			a.write(36); b.write(255); c.write(16); d.write(87);
			wait();
			assert(inx.read() == 21);
			assert(iny.read() == 73);

			
			a.write(169); b.write(1); c.write(61); d.write(39);
			wait();
			assert(inx.read() == 80);
			assert(iny.read() == 209);
			
			a.write(143); b.write(98); c.write(127); d.write(230);
			wait();
			assert(inx.read() == 58);
			assert(iny.read() == 90);
			
			a.write(29); b.write(78); c.write(176); d.write(75);
			wait();
			assert(inx.read() == 19);
			assert(iny.read() == 166);
		}
	}
	
	SC_CTOR(testert)
	{
		SC_CTHREAD(test,clk);
	}
	
};

int sc_main(int argc, char* argv[])
{
	sc_signal<sc_uint<8> > a,b,c,d, x,y;

	sc_clock clk;
	
	byte_mixcolum bm("bm");
	bm.a(a);
	bm.b(b);
	bm.c(c);
	bm.d(d);
	bm.outx(x);
	bm.outy(y);

	testert tester("tester");
	tester.a(a);
	tester.b(b);
	tester.c(c);
	tester.d(d);
	tester.inx(x);
	tester.iny(y);
	tester.clk(clk);

#if 0
	sc_trace_file* ptf = sc_create_vcd_trace_file("byte_mixcolum_test");
	sc_trace<sc_uint<8> >(ptf,a,"a");
	sc_trace<sc_uint<8> >(ptf,b,"b");
	sc_trace<sc_uint<8> >(ptf,c,"c");
	sc_trace<sc_uint<8> >(ptf,d,"d");
	sc_trace<sc_uint<8> >(ptf,x,"x");
	sc_trace<sc_uint<8> >(ptf,y,"y");
#endif
	
	sc_start(5000,SC_US);
	return 0;
}
