#include <systemc.h>
#include <iostream>
#include "des.h"


SC_MODULE(testert)
{
  sc_in <bool> clk;
  
  sc_out < bool > reset;

  sc_out < bool > load;
  sc_out < bool > decrypt;
  sc_out < sc_uint < 64 > > data_o;
  sc_out < sc_uint < 64 > >key;

  sc_in < sc_uint < 64 > > data_i;
  sc_in < bool > ready;

  void test()
  {
	  sc_uint<64> data;
	  data = 0xdeadbeef;
	  data <<= 32;
	  data |= 0xdeadbeef;

	  sc_uint<64> k;
	  k = 0xfb16c632;
	  k <<= 32;
	  k |= 0xab844fd8;
	  key = k;
	  
	  reset = true;

	  while(true)
	  {
	    // encrypt
	    load = true;
	    data_o = data;
	    decrypt = false;
	    do
	    {
		  wait();
	    }
	    while(!clk.posedge());

	    assert(data != data_i.read());

	  
	    load = false;

	    do
	    {
		  wait();

	    }while( ready.read() != true);

	    sc_uint<64> next_data = data_i;
	    
	    // decrypt
	    load = true;
	    data_o = data_i;
	    decrypt = true;

	    do
	    {
		  wait();
	    }
	    while(!clk.posedge());

	    load = false;

	    do
	    {
		  wait();

	    }while( ready.read() != true);

	    assert(data == data_i.read());
	    data = next_data;

#if 1
      std::cout << data.range(63,32) << "'"
        << data.range(31,0) << std::endl;
#endif

	  }
  }

  SC_CTOR(testert)
  {
	  SC_CTHREAD(test,clk.pos());
  }

};



int sc_main(int argc, char* argv[])
{
  sc_clock clk;
  sc_signal < bool > reset;

  sc_signal < bool > load;
  sc_signal < bool > decrypt;
  sc_signal < sc_uint < 64 > > a;
  sc_signal < sc_uint < 64 > >key;

  sc_signal < sc_uint < 64 > > b;
  sc_signal < bool > ready;

  des d("des");
  d.clk(clk);
  d.reset(reset);
  d.load_i(load);
  d.decrypt_i(decrypt);
  d.data_i(a);
  d.key_i(key);
  d.data_o(b);
  d.ready_o(ready);

  testert test("tester");
  test.clk(clk);
  test.reset(reset);
  test.load(load);
  test.decrypt(decrypt);
  test.data_o(a);
  test.key(key);
  test.data_i(b);
  test.ready(ready);

#if 0
  sc_trace_file* ptf = sc_create_vcd_trace_file("des");
  sc_trace<sc_uint<64> >(ptf,a, "a");
#endif
  sc_start(1000000, SC_NS);

#if 0
  sc_close_vcd_trace_file(ptf);
#endif
  
  return 0;
}
