#include <systemc.h>
#include <stdlib.h>
#include <iostream>
#include "key_gen.h"
SC_MODULE(testt)
{
	sc_in<bool> clk;

	key_gen kg1;
	sc_signal < sc_uint<56> > previous_key;
	sc_signal < sc_uint <4> > iteration;
	sc_signal < bool > decrypt;

	sc_signal< sc_uint<56> > non_perm_key;
	sc_signal< sc_uint<48> > new_key;

	void test()
	{
		int c = 0;
		while(true)
		{
			std::cout << c++ << std::endl;
			sc_uint <56> k0 =(sc_uint<56>) rand();
			previous_key = (sc_uint<56>) rand();
			iteration = (sc_uint<4>) rand();
			decrypt = (bool)(rand() & (~(RAND_MAX/2)));

			wait();

		}
	}

	SC_CTOR(testt): kg1("kg1")
	{
		SC_CTHREAD(test,clk.pos());

		kg1.previous_key(previous_key);
		kg1.iteration(iteration);
		kg1.decrypt(decrypt);
		kg1.non_perm_key(non_perm_key);
		kg1.new_key(new_key);
	}
};

int sc_main(int argc, char* argv[])
{
	sc_clock clk;
	testt tester("tester");
	tester.clk(clk);
	sc_start(10,SC_NS);
	return 0;
}
