#include<systemc.h>
#include <iostream>
#include "mixcolum.h"

//#define print_debug(x)   {std::cout <<__FILE__<<" "<< __LINE__ <<" "<< #x << " " << (x) << std::endl;} 
#define print_debug(x)   ;

SC_MODULE(testert)
{
	sc_in<bool> clk;

	sc_out<bool> reset;

	sc_out<bool> decrypt;
	sc_out<bool> start;
	sc_out<sc_biguint<128> > data_o;

	sc_in<bool> ready;
	sc_in<sc_biguint<128> > data_i;


	void test()
	{
		sc_biguint<128> data;

		data = 3737;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));

		data <<= 32;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));

		data |=  23939;
		
		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));

		data <<= 32;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));

		data |= -3779;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));

		data <<= 32;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));


		data |= -2774;

		print_debug(data.range(127,96));
		print_debug(data.range(95,64));
		print_debug(data.range(63,32));
		print_debug(data.range(31,0));


		print_debug(data_o.read().range(127,96));
		print_debug(data_o.read().range(95,64));
		print_debug(data_o.read().range(63,32));
		print_debug(data_o.read().range(31,0));



		reset = true;
		wait();

		print_debug(data_o.read().range(127,96));
		print_debug(data_o.read().range(95,64));
		print_debug(data_o.read().range(63,32));
		print_debug(data_o.read().range(31,0));

		while(true)
		{

			data_o = data;
			decrypt = false;

			print_debug(data_o.read().range(127,96));
			print_debug(data_o.read().range(95,64));
			print_debug(data_o.read().range(63,32));
			print_debug(data_o.read().range(31,0));

			wait();
			start = true;
			wait();
			start = false;
			do
			{
				wait();
			}
			 while(ready.read() != true);

			data_o = data_i.read();
			decrypt=true;

			wait();
			
			start = true;
			
			wait();

			start = false;
			do
			{
				wait();
        print_debug((int)ready.read());
			}while(ready.read() != true);

			std::cout << data_i.read().range(127,96) << "'"
				  << data_i.read().range(95,64) << "'"
				  << data_i.read().range(63,32) << "'"
				<< data_i.read().range(31,0) << std::endl;
			data = data_i.read();
			
			wait();
		}		
	}
	
	SC_CTOR(testert)
	{
		SC_THREAD(test);
		sensitive << clk.pos();

	}
};

int sc_main(int argc, char* argv[])
{
	sc_clock clk;
	sc_signal<bool> reset;
	sc_signal<bool> decrypt;
	sc_signal<bool> start;
	sc_signal<sc_biguint<128> > a;
	sc_signal<bool> ready;
	sc_signal<sc_biguint<128> > b;
	
	mixcolum mix("mix");
	mix.clk(clk);
	mix.reset(reset);
	mix.decrypt_i(decrypt);
	mix.start_i(start);
	mix.data_i(a);
	mix.ready_o(ready);
	mix.data_o(b);
	
	testert tester("tester");
	tester.clk(clk);
	tester.reset(reset);
	tester.decrypt(decrypt);
	tester.start(start);
	tester.data_i(b);
	tester.ready(ready);
	tester.data_o(a);

#if 0
	sc_trace_file* ptf = sc_create_vcd_trace_file("mixcolum_test");
	sc_trace<bool>(ptf,clk,"clk");
	sc_trace<bool>(ptf,reset,"reset");
	sc_trace<bool>(ptf,ready,"ready");
	sc_trace<bool>(ptf,decrypt,"decrypt");
	sc_trace<bool>(ptf,start,"start");
	sc_trace<sc_biguint<128> >(ptf,a,"a");
	sc_trace<sc_biguint<128> >(ptf,b,"b");
#endif
	

	sc_start(5000,SC_US);
	return 0;
}
