#include <systemc.h>
#include <iostream>


SC_MODULE(Modt)
{
  sc_mutex mutex;
  int data;

  void p1()
  {
    while(true)
    {
      mutex.lock();
      std::cout << "P1 enters critical section\n";
      data = 1;
      mutex.unlock();
      std::cout << "P1 exits critical section\n";
      wait(1,SC_NS);
    }
  }

  void p2()
  {
    while(true)
    {
      mutex.lock();
      data = 2;
      std::cout << "P2 enters critical section\n";
      mutex.unlock();
      std::cout << "P2 exits critical section\n";
      wait(1,SC_NS);
    }
  }

  void p3()
  {
    while(true)
    {
      mutex.lock();
      data = 3;
      std::cout << "P3 enters critical section\n";
      mutex.unlock();
      std::cout << "P3 exits critical section\n";
      wait(1,SC_NS);
    }
  }

  SC_CTOR(Modt)
  {
    SC_THREAD(p1);
    SC_THREAD(p2);
    SC_THREAD(p3);
  }
};

int sc_main(int argc, char* argv[])
{
  Modt m("mod");
  sc_start(10,SC_NS);
}
