#include <systemc.h>
#include <iostream>

int nondet_int();


SC_MODULE(stack_t)
{
	int buffer[10];
	int size;
	
	sc_in<int> cmd_in;
	sc_in<int> data_in;
	sc_in<bool> valid_in;
	
	sc_out<int>  data_out;
	sc_out<bool> valid_out;
	
	sc_out<bool> error_out;
	
	SC_CTOR(stack_t): size(5)
	{
		SC_THREAD(run);
		sensitive << valid_in;
		
	}

	void run()
	{

		while(true)
		{
			while(valid_in.read() == false)
			{
				wait();
			}


			switch(cmd_in.read())
			{
				case 0:
				{
					// push
					if(size == 10)
					{
						error_out.write(true);
					}
					else
					{
 						buffer[size] = data_in.read();
						size++;
					}
					break;
					
				}
				case 1:
				{
					// pop
					if(size == 0)
					{
						error_out.write(true);
					}
					else
					{
						data_out.write(buffer[size]);
						size--;
					}
					break;
				}
				case 2:
				{
					// size
					data_out.write(size);
					break;
				}
				default:
				{
					error_out.write(true);
				}
			}
			valid_out.write(true);

			
			while(valid_in.read() == true)
			{
				wait();
			}

			valid_out.write(false);
		}
	}
};

SC_MODULE(client_t)
{
	sc_out<int> cmd_out;
	sc_out<int> data_out;
	sc_out<bool> valid_out;
	
	sc_in<int>  data_in;
	sc_in<bool> valid_in;
	
	sc_in<bool> error_in;

	void run()
	{
		while(true)
		{
			int cmd;
			cmd = (nondet_int() & 1);
			
			cmd_out.write(cmd);

			if(cmd == 0)
			{
				int data = nondet_int();
				data_out.write(data);
			}
			
			valid_out.write(true);

			while(valid_in.read() == false)
			{
				wait();
			}

			assert(error_in.read() == false);
			
			valid_out.write(false);

			while(valid_in.read() == true)
			{
				wait();
			}
		}
	}

	SC_CTOR(client_t)
	{
		SC_THREAD(run);
		sensitive << valid_in;
	}
};

int sc_main(int c, char* argv [])
{
	stack_t stack("stack");
	client_t client("client");

	sc_signal<int> cmd, data1, data2;
	sc_signal<bool> valid1, valid2, error;

	stack.cmd_in(cmd);
	stack.data_in(data1);
	stack.valid_in(valid1);
	stack.data_out(data2);
	stack.valid_out(valid2);
	stack.error_out(error);

	client.cmd_out(cmd);
	client.data_out(data1);
	client.valid_out(valid1);
	client.data_in(data2);
	client.valid_in(valid2);
	client.error_in(error);

	sc_start(1000,SC_NS);
	
	return 0;
}
