#include <systemc.h>
#include "sbox.h"
#include "subbytes.h"

SC_MODULE(testert)
{
	sc_in<bool> clk;
	sc_out<bool> reset;

	sc_out<bool> start;
	sc_out<bool>decrypt;
	
	sc_out<sc_biguint<128> > data_o;
	sc_in<sc_biguint<128> > data_i;
	sc_in<bool> ready;

	

	void test()
	{
		sc_biguint<128> data =  91666365;
		reset = true;

		wait();
		
		while(true)
		{
		

		// encrypt
		data_o = data;
		decrypt= 0;
		start = true;
		
		do
		{
			wait();
		} while(!clk.posedge());
		
		start = false;

		do
		{
			wait();	
		} while( ready.read() != true);

		sc_biguint<128> next_data = data_i;
		// decrypt
		data_o = data_i;
		decrypt = true;
		start = true;
		do
		{
			wait();
		} while(!clk.posedge());
		start = false;
		
		do
		{
			wait();
		} while( ready.read() != true);

		assert(data == data_i.read());
		data = next_data;
		}
	}
	
	SC_CTOR(testert)
	{
		SC_CTHREAD(test,clk);
	}
	
};

int sc_main(int argc, char* argv[])
{
 	sc_clock clk;
	sc_signal<bool> reset;

	sc_signal<bool> start;
	sc_signal<bool> decrypt;
	sc_signal<sc_biguint <128> > a;

	sc_signal<bool> ready;
	sc_signal<sc_biguint<128> > b;

	sc_signal<sc_uint<8> > sbox_a;
	sc_signal<sc_uint<8> > sbox_b;
	sc_signal<bool>sbox_decrypt;


	subbytes sub("sub");
	sub.clk(clk);
	sub.reset(reset);
	sub.start_i(start);
	sub.decrypt_i(decrypt);
	sub.data_i(a);
	sub.ready_o(ready);
	sub.data_o(b);
	sub.sbox_data_o(sbox_a);
	sub.sbox_data_i(sbox_b);
	sub.sbox_decrypt_o(sbox_decrypt);

	sbox sb("sbox");
	sb.clk(clk);
	sb.reset(reset);
	sb.data_i(sbox_a);
	sb.decrypt_i(sbox_decrypt);
	sb.data_o(sbox_b);
	

	testert tester("tester");
	tester.clk(clk);
	tester.reset(reset);
	tester.start(start);
	tester.decrypt(decrypt);
	tester.data_o(a);
	tester.ready(ready);
	tester.data_i(b);

#if 0
	sc_trace_file* ptf = sc_create_vcd_trace_file("subbytes");
	sc_trace<bool>(ptf, clk,"clk");
//	sc_trace<bool>(ptf,reset,"rst");
	sc_trace<bool>(ptf,start,"start");
	sc_trace<bool>(ptf,ready, "ready");
	sc_trace<bool>(ptf,sbox_decrypt, "sbox_decrypt");
	sc_trace<sc_uint<8> >(ptf,sbox_a, "sbox_a");
	sc_trace<sc_uint<8> >(ptf,sbox_b, "sbox_b");
	sc_trace<sc_biguint<128> >(ptf,sub.data_reg, "data_reg");
	sc_trace<sc_biguint<128> >(ptf,sub.next_data_reg, "next_data_reg");
	
	sc_trace<sc_biguint<128> >(ptf,a, "a");
	sc_trace<sc_biguint<128> >(ptf,b, "b");
#endif
	
	sc_start(5000,SC_US);

#if 0
	sc_close_vcd_trace_file(ptf);
#endif


	return 0;
}
