/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/

#ifndef TLM_FIFO_PORTS_HEADER
#define TLM_FIFO_PORTS_HEADER

#include <tlm.h>

#ifndef __SCOOT__
#include <tlm_h/tlm_req_rsp/tlm_1_interfaces/tlm_core_ifs.h>
#endif

namespace tlm
{
	
//---------------------------------------------------------------
// tlm-fifo non-blocking input port
//---------------------------------------------------------------

template <class T>
class tlm_fifo_nb_in: public sc_port<tlm_nonblocking_get_peek_if<T> >
{
  typedef tlm_nonblocking_get_peek_if<T> IF;
  public:
  tlm_fifo_nb_in(){}
  tlm_fifo_nb_in(const char* name):
#ifdef __SCOOT__
    sc_port(name)
#else
    sc_port<tlm_nonblocking_get_peek_if<T> >(name)
#endif
    {}

  bool nb_get(T& t)
  {
    return (*this)->nb_get(t);
  }

  bool nb_peek(T& t) const
  {
    return (*this)->nb_peek(t);
  }

  private:

  tlm_fifo_nb_in(const tlm_fifo_nb_in&);            // disabled
  tlm_fifo_nb_in& operator=(const tlm_fifo_nb_in&); // disabled


};


//---------------------------------------------------------------
// tlm-fifo non-blocking output port
//---------------------------------------------------------------

template <class T>
class tlm_fifo_nb_out: public sc_port<tlm_nonblocking_put_if<T> >
{
  typedef tlm_nonblocking_put_if<T> IF;
  public:
  tlm_fifo_nb_out(){}
  tlm_fifo_nb_out(const char* name): 
#ifdef __SCOOT__
    sc_port(name)
#else 
    sc_port<tlm_nonblocking_get_peek_if<T> >(name)
#endif
    {}

  bool nb_put(const T& t)
  {
    return (*this)->nb_put(t);
  }

private:
  tlm_fifo_nb_out(const tlm_fifo_nb_out&);            // disabled
  tlm_fifo_nb_out& operator=(const tlm_fifo_nb_out&); // disabled
};

}
#endif

