#include <systemc.h>

SC_MODULE(module)
{
	sc_clock clk;

	sc_signal<int> sig;
	
	void mod1_proc()
	{
		int val = 1;
		while(true)
		{
			sig.write(val);
			wait(10);
			val++;
		}
	}

	void mod2_proc()
	{
		wait();
		assert(sig.read() == 1);

		while(true)
		{
			int count = 0;
			int rd = sig.read();
			while(sig.read() == rd)
			{
				wait();
				count++;
			}
			// assertion shall be broken
			assert(count != 10);
		}
	}
	
	SC_CTOR(module)
	{
		SC_CTHREAD(mod1_proc,clk);
		SC_CTHREAD(mod2_proc,clk);
	}
};

int sc_main(int i, char* argv [])
{
	module m("module");
	sc_start(1,SC_SEC);
	return 0;
}
