#include <systemc.h>
#include "word_mixcolum.h"

SC_MODULE(testert)
{
	sc_out<sc_uint<32> > out;
	sc_in<sc_uint<32> > inx, iny;
	
	sc_in<bool> clk;

	void test()
	{
		while(true)
		{
			out = 0x56af019f;
			wait();
			assert(inx.read() == 0xd88f4171);
			assert(iny.read() == 0x8a5a13a4);

			out = 0xc6a60121;
			wait();
			assert(inx.read() == 0x46b301b4);
			assert(iny.read() == 0x41af06a8);

			out = 0x0606f121;
			wait();
			assert(inx.read() == 0xd6239abf);
			assert(iny.read() == 0xfd65b1f9);

			out = 0x0a66f127;
			wait();
			assert(inx.read() == 0x68e9fcc7);
			assert(iny.read() == 0x0e519a7f);
		}
	}
	
	SC_CTOR(testert)
	{
		SC_CTHREAD(test,clk);
	}
	
};

int sc_main(int argc, char* argv[])
{
	sc_signal<sc_uint<32> > s;
	sc_signal<sc_uint<32> > x, y;
	

	sc_clock clk;
	
	word_mixcolum wm("bm");
	wm.in(s);
	wm.outx(x);
	wm.outy(y);

	testert tester("tester");
	tester.out(s);
	tester.inx(x);
	tester.iny(y);
	tester.clk(clk);

#if 0

	sc_trace_file* ptf = sc_create_vcd_trace_file("word_mixcolum_test");
	sc_trace<sc_uint<32> >(ptf,s,"s");
	sc_trace<sc_uint<32> >(ptf,x,"x");
	sc_trace<sc_uint<32> >(ptf,y,"y");
#endif
	sc_start(5000,SC_US);
	return 0;
}
