/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef  __ARRAYBV_H
#define  __ARRAYBV_H

#include <assert.h>
#include <stdio.h>

template<class T, unsigned W>
class __array
{
  public:

    __array(){}

    explicit __array(const __array& ref)
    {
      memcpy(array,ref.array,sizeof(T[W]));
    }

    explicit __array(const T& ref)
    {
      for(unsigned i = 0; i < W; i++)
        (*this)[i] = ref;
    }

    __array& operator=(const __array& ref)
    {
      if(&ref != this)
        memcpy(array,ref.array,sizeof(T[W]));
    }

    T& operator[](const __unsignedbv<UINT_BSIZE>& index)
    {
#ifdef __BV_DEBUG
      assert(index.to_unsigned() < W);
#endif
      return array[index.to_unsigned()];
    }

    T& operator[](int index)
    {
#ifdef __BV_DEBUG
      assert(0 <= index && index < W);
#endif
      return array[index];
    }


    bool operator == (const __array& ref) const
    {
      if(array == ref.array)
        return true;
      return (memcmp(array,&ref,sizeof(T[W])) == 0);
    }

    operator T* ()
    {
      return array;
    }

  private:

    T array[W];
};


template<class T, unsigned W>
class __const_with
{
  public:

    __const_with(const __array<T,W>& src, const __unsignedbv<UINT_BSIZE>& index, const T& value):
      array(src)
  {
#ifdef __BV_DEBUG
    assert(index.to_unsigned() < W);
#endif

    array[index.to_unsigned()] = value; 
  }

    operator __array<T,W>& ()
    { return array; }

  private:
    __array<T,W> array;
};

template<class T, unsigned W>
class __with
{
  public:

    __with(__array<T,W>& src, const __unsignedbv<UINT_BSIZE>& index, const T& value):
      parray(&src)
  {
#ifdef __BV_DEBUG
    assert(index.to_unsigned() < W);
#endif

    (*parray)[index.to_unsigned()] = value; 
  }

    operator __array<T,W>& ()
    { return *parray; }

  private:
    __array<T,W>* parray;
};




#endif
