/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
 \*******************************************************************/

#ifndef __BV_H
#define __BV_H

#define __INLINE inline
//#define __BV_DEBUG

#include <__signedbv.h>
#include <__unsignedbv.h>
#include <__verilogbv.h>
#include <__array.h>


// Conversion constructor form __unsignedbv to __signedbv
template<int W1> template <int W2>
  inline
__signedbv<W1>::__signedbv(const __unsignedbv<W2>& bv)
{
  if(W1 <= W2)
  {
    for(unsigned i = 0; i < SIGNEDBV_SIZEOF_DATA(data); i++)
      data_at(i) = bv.data_at(i);

    if( (W1%(sizeof(int)*8)) != 0)
    {

      data_at(SIGNEDBV_SIZEOF_DATA(data)-1) <<= (sizeof(int)*8 - (W1%(sizeof(int)*8)));

      data_at(SIGNEDBV_SIZEOF_DATA(data)-1) >>= (sizeof(int)*8 - (W1%(sizeof(int)*8)));
    }
  }
  else
  {
    for(unsigned i = 0; i < UNSIGNEDBV_SIZEOF_DATA(bv.data); i++)
      data_at(i) = bv.data_at(i);

    for(unsigned i =  UNSIGNEDBV_SIZEOF_DATA(bv.data); i < SIGNEDBV_SIZEOF_DATA(data); i++)
      data[i] = 0;
  }
}

// Conversion constructor form __signedbv to __unsignedbv
template<int W1> template <int W2>
  inline
__unsignedbv<W1>::__unsignedbv(const __signedbv<W2>& bv)
{
  if(W1 <= W2)
  {
    for(unsigned i = 0; i < UNSIGNEDBV_SIZEOF_DATA(data); i++)
      data[i] = bv.data[i];

    if( (W1%(sizeof(int)*8)) != 0)
    {
      int c = sizeof(unsigned int)*8 - (W1%(sizeof(unsigned int)*8));
      data[UNSIGNEDBV_SIZEOF_DATA(data)-1] <<= c;
      data[UNSIGNEDBV_SIZEOF_DATA(data)-1] >>= c;
    }
  }
  else
  {
    for(unsigned i = 0; i < SIGNEDBV_SIZEOF_DATA(bv.data); i++)
      data[i] = bv.data[i];

    for(unsigned i =  SIGNEDBV_SIZEOF_DATA(bv.data); i < UNSIGNEDBV_SIZEOF_DATA(data); i++)
      data[i] = 0;
  }
}

#endif
