/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef __SCHEDULE_H
#define __SCHEDULE_E

#include <__signedbv.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include <set>
#include <map>
#include <list>
#include <unistd.h>
#include <stdio.h>

#define IF_DEBUG(x) x

__signedbv<32> __scoot_next_schedule( bool runnable_table[], bool (**palt_table)(), bool * pindep_table, __signedbv<32> n )
{

  std::set<int> runnable;
  static std::set<int> sleeps;

#ifndef RANDOM_SEARCH
  static std::ofstream pout;
  static std::ifstream pin;
#endif

  // initialization code
  static bool initialized = false;
  if(!initialized)
  {
    initialized = true;
#ifdef RANDOM_SEARCH
    //		unsigned seed;	
    //		std::cout << "Random seed? ";
    //		std::cin  >> seed;
#else
    pout.open("./scoot_sim.pipe.out", std::ofstream::out);
    pin.open("./scoot_sim.pipe.in", std::ifstream::in);
#endif
  }

  for(int i = 0; i < n.to_int(); i++)
  {
    if(runnable_table[i])
      runnable.insert(i);
  }


  IF_DEBUG(std::cout << "Runnable processes: " << runnable.size() << std::endl);

  if(runnable.empty())
    return __signedbv<32>(-1);

  // Persistent
  std::set<int> persistents;

#ifdef PERSISTENT_SET
  for(std::set<int>::const_iterator pi_it = runnable.begin(); pi_it != runnable.end(); pi_it++)
  {
    int pi = *pi_it;
     // We assume that all processes are runnable
    for(int pj = 0; pj < n.to_int(); pj++)
    {
      if(pi == pj) continue;

      bool (*pfunc)() = palt_table[pi*n.to_int()+pj]; 
      bool indep = (*pfunc)();
      if(indep)
      {
        IF_DEBUG(std::cout <<"Indep " << pi  << ", " << pj << std::endl);
        if(persistents.count(pi) == 0)
          persistents.insert(pj);
      }
      else
      {
        persistents.insert(pi);
        persistents.insert(pj);
      }

    }
  }
  // Now we remove non-runnable processes
  for(std::set<int>::iterator it = persistents.begin();
      it != persistents.end();)
  {
    std::set<int>::iterator curr_it = it++;
    int p = * curr_it;
    if(runnable_table[p] == false)
      persistents.erase(curr_it);
  }
  // If only one process is runnable then persistent is empty.
  if(persistents.empty())
  {
     assert(runnable.size() == 1);
     persistents = runnable;
  }
#else
  persistents = runnable;
#endif

  IF_DEBUG(std::cout <<"Persistent set: " << persistents.size() << " proc." << std::endl);
  IF_DEBUG(std::cout <<"Sleep set: " << sleeps.size() << " proc." << std::endl);

  std::set<int> awakes;

  for(std::set<int>::iterator it = persistents.begin(); it != persistents.end(); it++)
  {
    if(sleeps.count(*it) == 0)
      awakes.insert(*it);
  }

  if(awakes.empty())
  {
    IF_DEBUG(std::cout << "Set awakes is empty" << std::endl);
    exit(0);
  }
  std::map<int, std::set<int> > next_sleeps;

#ifdef SLEEP_SET
  for(std::set<int>::const_iterator it1 = awakes.begin();
      it1 != awakes.end(); it1++)
  {
    int pi = *it1;
    for(std::set<int>::const_iterator it2 = sleeps.begin();
        it2 != sleeps.end(); it2++)
    {
      int pj = *it2;
      bool (*pfunc)() = palt_table[pi*n.to_int()+pj]; 
      bool indep = (*pfunc)();
      if(indep) next_sleeps[pi].insert(pj);
    }
    sleeps.insert(pi);
  }
#endif

#ifdef RANDOM_SEARCH
  // pickup process randomly
  {
    int rnd = random();
    std::cout << "rnd " << rnd <<std::endl;
    int inc = RAND_MAX/awakes.size();
    std::set<int>::const_iterator pit = awakes.begin();
    for(int counter = inc; counter < rnd; counter += inc)
    {
      pit++;
    }
    assert( pit != awakes.end());
    sleeps = next_sleeps[*pit];
    runnable.erase(*pit);

    IF_DEBUG(std::cout << "scheduling " << *pit << std::endl);
    runnable_table[*pit] = false;
    return __signedbv<32>(*pit);
  }
#else
  IF_DEBUG(std::cout << "Simulator sending " << awakes.size() << std::endl);
  pout << awakes.size() << std::endl;
  pout.flush();
  int next;
  IF_DEBUG(std::cout << "Simulator: Waiting for reply\n");
  pin >> next;
  IF_DEBUG(std::cout << "Simulator: recieved " << next << std::endl);

  assert(next >=0 && next < awakes.size());
  std::set<int>::iterator ita = awakes.begin();
  for(int i =0; i < next; i++)ita++;

  IF_DEBUG(std::cout << "scheduling " << *ita << std::endl);

  runnable.erase(*ita);
  sleeps = next_sleeps[*ita];

  runnable_table[*ita] = false;
  return __signedbv<32>(*ita);
#endif

}

#endif
