/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
 \*******************************************************************/


#include <iostream>
#include <string>

template <int W> class __verilogbv;

enum Logic {Logic_0, Logic_1, Logic_Z, Logic_X};

template <int W>
class __verilogbv
{
  public:

    // Constructors

    __verilogbv(){};
    __verilogbv(Logic){};

    __verilogbv(const __verilogbv<W>& bv)
    {
      *this = bv;
    }

    __verilogbv(unsigned char binstr [W+1]);

    // Logical assignment operators
    __verilogbv& operator&=(const __verilogbv<W>& bv);
    __verilogbv& operator|=(const __verilogbv<W>& bv);
    __verilogbv& operator^=(const __verilogbv<W>& bv);

    // Arithemtic assignment operators

    __verilogbv& operator +=(const __verilogbv&);
    __verilogbv& operator -=(const __verilogbv&);
    __verilogbv& operator *=(const __verilogbv&);
    __verilogbv& operator /=(const __verilogbv&);
    __verilogbv& operator %=(const __verilogbv&);

    // Bits extraction
    template<int W2>
      __verilogbv(const __verilogbv<W2>& bv, int left, int right);


    // Assignment operator

    __verilogbv& operator=(const __verilogbv<W>& bv)
    {
      for(unsigned i = 0; i < DATA_SIZE; i++)
        this->data[i] = bv.data[i];
      return *this;
    }

    // Shifting operators

    __verilogbv&  operator <<= (int);
    __verilogbv&  operator >>= (int);


    // Comparison operators

    friend bool operator==(const __verilogbv& bv1, const __verilogbv& bv2)
    {
      for(unsigned i = 0; i < DATA_SIZE; i++)
        if(bv1.data[i] != bv2.data[i])
          return false;
      return true;
    }

    // Bit extraction
    Logic operator[](unsigned i) const
    {
#ifdef __BV_DEBUG
      assert(i < W);
#endif
      return this->data[i];
    }

  private:
    static const int DATA_SIZE = W;
    Logic data[DATA_SIZE];
};

// Binary comparision operators


  template<int W>
bool operator !=(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  return !(bv1 == bv2);
}

// Binary logical operators

  template<int W>
__verilogbv<W> operator & (const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp &= bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator | (const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp |= bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator ^ (const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp ^= bv2;
  return  tmp;
}

// Binary arithmetic operators

  template<int W>
__verilogbv<W> operator +(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp += bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator -(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp -= bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator *(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp *= bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator /(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp /= bv2;
  return  tmp;
}

  template<int W>
__verilogbv<W> operator %(const __verilogbv<W>& bv1, const __verilogbv<W>& bv2)
{
  __verilogbv<W> tmp(bv1);
  tmp %= bv2;
  return  tmp;
}


#define LOGIC_0 (__verilogbv<1>(Logic_0))
#define LOGIC_1 (__verilogbv<1>(Logic_1))
#define LOGIC_Z (__verilogbv<1>(Logic_Z))
#define LOGIC_X (__verilogbv<1>(Logic_X))
