/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_CLOCK_H
#define SC_CLOCK_H

#include<sc_signal.h>
#include<sc_signal_ports.h>

namespace sc_core
{
  class sc_clock: public sc_signal<bool>
  {
    public:

      //
      // Clock settings:
      //   Period: 2 * time resolution
      //   Duty Cycle: 50%
      //   Start Time: 0
      //   Posedge First: true
      //

      sc_clock(){};

      explicit sc_clock(const char* name):sc_signal(name){};

    private:

      // The purpose of this function requires some explanations: Scoot
      // simplifes the way clock signals are generated. After exiting the
      // delta loop, the scheduler calls the 'timed_update' function, whose
      // purpose is to invert the clock.
      void timed_update()
      {
        previous_value = current_value;
        current_value = !current_value;
        next_value =  current_value;

#ifdef SCOOT_SKIP_NOTIFICATION_PHASES

        _value_changed_event.do_notify(true);
        if(current_value == true)
          _posedge_event.do_notify(true);
        else
          _negedge_event.do_notify(true);

#else

        _value_changed_event.notify(1);
        if(current_value == true)
          _posedge_event.notify(1);
        else
          _negedge_event.notify(1);

#endif
      }

      // Disabled
      sc_clock(const sc_clock&);
  };

  typedef sc_in<bool> sc_in_clk;
}


#endif
