/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_EVENT_H
#define SC_EVENT_H

#include <scoot_tags.h>
#include <sc_time.h>
namespace sc_core
{

  class sc_event_finder
  {};
#ifdef SCOOT_SKIP_NOTIFICATION_PHASES
  struct sc_event
  {
    sc_event():value(false)
    {
      scoot_event_decl(this);
    }

    bool notified() const
    {
      return value;
    }

    void do_notify(bool v)
    {
      value = v;
    }

    bool value;
  };
#else
  class sc_event
  {
    public:
      sc_event():value(false), next_value(false), counter(-1LL)
    {
      scoot_event_decl(this);
    }

      void notify()
      {
        value = true;
        next_value = false;
        counter = 0;
        scoot_notify_processes();
      }

      void notify(const sc_time& t)
      {
        if(t.value() == 0LL)
        {
          next_value = true;
          counter = -1LL;
        }
        else if(next_value == false)
        {
          counter = t.value();
        }
      }

      void notify(long long int i)
      {
        if(i == 0LL)
        {
          next_value = true;
          counter = -1LL;
        }
        else if(next_value == false)
        {
          counter = i;
        }
      }

      bool notified() const
      {
        return value;
      }

    private:

      void do_delta_notification()
      {
        value = next_value;
        next_value = false;
      }

      void do_timed_notification()
      {
        if(0LL <= counter) counter--;
        value = (counter == 0LL);
      }
      bool value;
      bool next_value;
      bool timed_notification;
      long long int counter;
  };
#endif

} // namespace sc_core
#endif
