/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
 \*******************************************************************/


#ifndef SC_FIFO_PORTS_H
#define SC_FIFO_PORTS_H

#include <sc_fifo.h>

namespace sc_core {

  class sc_fifo_port_base: scoot_port
  {
    public:

      sc_fifo_port_base()
      {
      }

      explicit sc_fifo_port_base(char * name)
      {
      }

    private:
      sc_fifo_port_base(const sc_fifo_port_base&); // Disabled
  };

  template <class T>
    class sc_fifo_in: sc_fifo_port_base
  {
    public:

      sc_fifo_in(){};
      explicit sc_fifo_in( const char* ){};

      void read( T& t)
      {
        ((sc_fifo<T>*)channel)->read(t);
      }

      T read()
      {
        return ((sc_fifo<T>*)channel)->read();
      }

      bool nb_read( T& t)
      {
        return ((sc_fifo<T>*)channel)->nb_read(t);
      }

      const sc_event& data_written_event() const
      {
        return ((sc_fifo<T>*)channel)->data_written_event();
      }

      const sc_event_finder& data_written() const
      {
        return _data_written;
      }

      int num_available() const
      {
        return ((sc_fifo<T>*)channel)->num_available();
      }

      void operator()(sc_fifo<T>& f)
      { scoot_port_to_channel_binding(this,&f); }

      void operator()(sc_fifo_in<T>& p)
      { scoot_port_to_port_binding(this,&p); }

    private:
      // Disabled
      sc_fifo_in( const sc_fifo_in<T>& );
      sc_fifo_in<T>& operator= ( const sc_fifo_in<T>& );

      sc_event_finder _data_written;
  };

  template <class T>
    class sc_fifo_out: sc_fifo_port_base
  {
    public:

      sc_fifo_out(){};
      explicit sc_fifo_out( const char* ){};

      void write(const T& t)
      {
        ((sc_fifo<T>*)channel)->write(t);
      }

      bool nb_write(const T& t)
      {
        return ((sc_fifo<T>*)channel)->nb_write(t);
      }

      const sc_event& data_read_event() const
      {
        return ((sc_fifo<T>*)channel)->data_read_event();
      }

      const sc_event_finder& data_read() const
      {
        return _data_read;
      }

      int num_free() const
      {
        return ((sc_fifo<T>*)channel)->num_free();
      }

      void operator()(sc_fifo<T>& f)
      { scoot_port_to_channel_binding(this, &f); }

      void operator()(sc_fifo_out<T>& p)
      { scoot_port_to_port_binding(this,&p); }

    private:
      // Disabled
      sc_fifo_out( const sc_fifo_out<T>& );
      sc_fifo_out<T>& operator= ( const sc_fifo_out<T>& );

      sc_event_finder _data_read;
  };

} // namespace sc_core

#endif
