/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_MODULE_H
#define SC_MODULE_H

#include <scoot_tags.h>

#include <sc_sensitive.h>
#include <sc_signal.h>
#include <sc_event.h>
#include <sc_time.h>

namespace sc_core
{

  class sc_module_name
  {
    public:
      sc_module_name( const char* ps ): ps(ps){}
      sc_module_name( const sc_module_name& name): ps(name.ps){};
      operator const char*() const {return ps;};
    private:
      // Disabled
      sc_module_name();
      sc_module_name& operator= ( const sc_module_name& );

      const char* ps;
  };



  class sc_module
  {
    public:

      // Constructors

      sc_module()
      {
        scoot_module_decl(this);
      }

      sc_module(const char* )
      {
        scoot_module_decl(this);
      }

      sc_module(const sc_module_name&)
      {
        scoot_module_decl(this);
      }

      void dont_initialize()
      { scoot_dont_initialize(); }

    private:

      // Disabled

      sc_module( const sc_module& );
      sc_module& operator=(const sc_module&);
  };


  // -----------------------------------------------------------------------------
  // SOME MACROS TO SIMPLIFY SYNTAX:
  // -----------------------------------------------------------------------------

#define SC_MODULE(user_module_name)                                           \
  struct user_module_name : ::sc_core::sc_module

#define SC_CTOR(user_module_name)                                             \
  typedef user_module_name SC_CURRENT_USER_MODULE;                          \
  private:                                                                  \
                                                                            user_module_name(const user_module_name&);                                \
  user_module_name& operator = (const user_module_name&);                   \
  public:                                                                   \
                                                                            user_module_name(const char*)

  // the SC_HAS_PROCESS macro call must be followed by a ;
#define SC_HAS_PROCESS(user_module_name)                                      \
  private:                                                                  \
                                                                            user_module_name(const user_module_name&);                                \
  user_module_name& operator = (const user_module_name&);                   \
  public:                                                                   \
                                                                            typedef user_module_name SC_CURRENT_USER_MODULE                           \

  //-----------------------------------------------------------------------------
  // PROCESS DECLARATION
  //-----------------------------------------------------------------------------

  template <class T>
    void sc_thread(T* pobject, void (T::* pmethod)());

  template <class T>
    void sc_cthread(T* pobject, void (T::* pmethod)());

  template <class T>
    void sc_method(T* pobject, void (T::* pmethod)());


#define SC_CTHREAD(handle, edge)                                              \
  {                                                                             \
    sc_cthread<SC_CURRENT_USER_MODULE>(this, &SC_CURRENT_USER_MODULE::handle);\
    sensitive << (edge);                                                      \
  }                                                                             \

#define SC_THREAD(handle)                                                     \
  {                                                                             \
    sc_thread<SC_CURRENT_USER_MODULE>(this, &SC_CURRENT_USER_MODULE::handle);\
  }

#define SC_METHOD(handle)                                                     \
  {                                                                             \
    sc_method<SC_CURRENT_USER_MODULE>(this, &SC_CURRENT_USER_MODULE::handle);\
  }

  //-----------------------------------------------------------------------------
  // START SIMULATION
  //-----------------------------------------------------------------------------

  inline void sc_start(const sc_time& time)
  {
    scoot_start(scoot_simulation_time + time.value());
  }

  inline void sc_start(long long time, sc_time_unit res)
  {
    sc_time t(time,res);
    sc_start(t);
  }

  inline void sc_start(long long time)
  {
    scoot_start(scoot_simulation_time + time);
  }

} // namespace sc_core

#endif
