/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/

#ifndef SC_PORTS_H
#define SC_PORTS_H

#include <scoot_tags.h>
#include <sc_event.h>

namespace sc_core{

  class sc_port_base:  public scoot_port
  {
    public:
      sc_port_base(){};
      sc_port_base(const char* name):scoot_port(){};

      const sc_event_finder& value_changed() const
      {
        return _value_changed_event;
      }

    private:

      sc_port_base(const sc_port_base&);
      sc_port_base& operator=(const sc_port_base&);

      sc_event_finder _value_changed_event;
  };


  template <class IF>
    class sc_port: public sc_port_base
  {
    public:

      // Constructors

      sc_port(){};
      explicit sc_port(const char* name):sc_port_base(name){};

      // Syntaxic sugar

      void operator()(IF& _if)
      { scoot_port_to_channel_binding(this,& _if.get_channel()); }

      void operator()(sc_port<IF>& port)
      { scoot_port_to_port_binding(this, &port); }

      IF* operator->()
      { return  channel; }

      const IF* operator->() const
      { return channel; }

      IF* get_channel() { return channel; }
      const IF* get_channel() const { return channel; }

    private:

      IF* channel;

      // Disabled

      sc_port(const sc_port&);
      sc_port& operator=(const sc_port&);

  };
}

#endif


