/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_SENSITIVE_H
#define SC_SENSITIVE_H

#include <scoot_tags.h>

#include <sc_signal.h>
#include <sc_signal_ports.h>
#include <sc_fifo.h>
#include <sc_fifo_ports.h>
#include <sc_event.h>

namespace sc_core
{


  class sc_sensitive
  {
    private:

      friend sc_sensitive& operator << (sc_sensitive& s, const sc_signal_base& sig)
      {
        scoot_event_sensitivity(&sig.value_changed_event());
        return s;
      }

     friend sc_sensitive& operator << (sc_sensitive& s, const sc_signal_port_base& port)
      {
        scoot_event_finder_sensitivity(&port.value_changed());
        return s;
      }

      friend sc_sensitive& operator << (sc_sensitive& s, const sc_event& e)
      {
        scoot_event_sensitivity(&e);
        return s;
      }

      friend sc_sensitive& operator << (sc_sensitive& s, const sc_event_finder& e)
      {
        scoot_event_finder_sensitivity(&e);
        return s;
      }
  };

  extern sc_sensitive sensitive;

}

#endif

// Taf!
