/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_SIGNAL_PORTS_H
#define SC_SIGNAL_PORTS_H

#include <sc_signal.h>
#include <sc_event.h>

namespace sc_core {

  class sc_signal_port_base: public scoot_port
  {
    public:

      sc_signal_port_base(){}

      explicit sc_signal_port_base(char * name):channel(0){}

      const sc_event_finder& value_changed() const
      { return _value_changed_event; }

    private:

      sc_signal_port_base(const sc_signal_port_base&); // Disabled

      sc_event_finder _value_changed_event;

    public:
      scoot_channel* channel;

  };

  template <class T>
    class sc_signal_port: public sc_signal_port_base
  {
    public:

      // Constructors

      sc_signal_port(){};
      explicit sc_signal_port(char* name):sc_signal_port_base(name){};
 
      void operator()(sc_signal<T>& sig)
      { scoot_port_to_channel_binding(this,&sig); }

      void operator()(sc_signal_port<T>& port)
      { scoot_port_to_port_binding(this,&port); }

      bool event() const
      { return ((const sc_signal<T>*) channel)->event(); }

      const sc_event& value_changed_event() const
      { return ((const sc_signal<T>*) channel)->value_changed_event(); }

    private:

      // Disabled

      sc_signal_port(const sc_signal_port&);

  };

  template <>
    class sc_signal_port<bool>: public sc_signal_port_base
    {
      public:

        // Constructors

        sc_signal_port(){};
        explicit sc_signal_port(char* name):sc_signal_port_base(name){};

        // Syntaxic sugar

        void operator()(sc_signal<bool>& sig)
        { scoot_port_to_channel_binding(this,&sig); }

        void operator()(sc_signal_port<bool>& port)
        { scoot_port_to_port_binding(this,&port); }

        bool event() const
        { return ((const sc_signal<bool>*) channel)->event(); }

        bool posedge() const
        { return ((const sc_signal<bool>*) channel)->posedge(); }

        bool negedge() const
        { return ((const sc_signal<bool>*) channel)->negedge(); }

        const sc_event_finder& value_changed() const
        { return _value_changed_event; }

        const sc_event& value_changed_event() const
        { return ((const sc_signal<bool>*) channel)->value_changed_event(); }

        const sc_event& posedge_event() const
        { return ((const sc_signal<bool>*) channel)->posedge_event(); }

        const sc_event& negedge_event() const
        { return ((const sc_signal<bool>*) channel)->negedge_event(); }

        const sc_event_finder& pos() const
        { return _posedge_event; }

        const sc_event_finder& neg() const
        { return _negedge_event; }

      private:

        sc_event_finder _value_changed_event;
        sc_event_finder _posedge_event;
        sc_event_finder _negedge_event;

        // Disabled

        sc_signal_port(const sc_signal_port&);

    };


  template <class T>
    class sc_in: public sc_signal_port<T>
  {
    public:

      // Constructors

      sc_in(){};
      explicit sc_in(const char*name){};

      // Read access

      T read() const  {
        return ((sc_signal<T>*)channel)->read();
      }

      // Syntaxic sugar

      operator T () const
      { return read();}

      bool operator == (const T t) const  {
        return ((sc_signal<T>*)channel)->read() == t;
      }

    private:

      // Disabled

      sc_in(const sc_in&);

  };

  template <class T>
    class sc_inout: public sc_signal_port<T>
  {
    public:

      // Constructors

      sc_inout(){};
      explicit sc_inout(const char* name){};

      // Access methods

      T read() const {
        return ((sc_signal<T>*)channel)->read();
      }

      void write(T t) {
        ((sc_signal<T>*)channel)->write(t);
      }

      // Syntaxic sugar
      operator T () const
      { return read(); }

      sc_inout<T>& operator = (T value)
      { write(value); return *this; }

      bool operator == (const T t) const  {
        return ((sc_signal<T>*)channel)->read() == t;
      }

    private:

      // Disabled

      sc_inout(const sc_inout&);
  };


#define sc_out sc_inout


#if 0
  typedef sc_in<sc_logic> sc_in_resolved;
  typedef sc_out<sc_logic> sc_out_resolved;
  typedef sc_inout<sc_logic> sc_inout_resolved;

  template <int W>
    class sc_in_rv: public sc_in<sc_lv<W> >
  {
    public:
      sc_in_rv(){};
    private:
      // Disabled
      sc_in_rv(const sc_in_rv&);
  };


  template <int W>
    class sc_out_rv: public sc_out<sc_lv<W> >
  {
    public:
      sc_out_rv(){};

    private:
      // Disabled
      sc_out_rv(const sc_out_rv&);
  };

  template <int W>
    class sc_inout_rv: public sc_inout<sc_lv<W> >
  {
    public:
      sc_inout_rv(){};

    private:
      // Disabled
      sc_inout_rv(const sc_inout_rv&);
  };
#endif

} // namespace sc_core

#endif
