/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef SC_WAIT_H
#define SC_WAIT_H

#include <sc_event.h>
#include <sc_time.h>

namespace sc_core
{

  // -----------------------------------------------------------------------------
  // WAIT FUNCTIONS:
  // -----------------------------------------------------------------------------

  void wait();

  inline void wait(int n)
  {
    for(int i = 0; i < n; i++)
      wait();
  }


  void wait(const sc_event& e);


  void wait(long long time); // wait for time

  inline void wait(const sc_time& t)
  {
    wait((long long)(scoot_simulation_time + t.value()));
  }


  inline void wait(long long n, sc_time_unit u)
  {
    wait(sc_time(n,u));
  }

}

#endif
