/*******************************************************************\
 *
 *
 * Author: Blanc Nicolas
 *
 * 
\*******************************************************************/


#ifndef CPROVER_SCOOT_TAGS_H
#define CPROVER_SCOOT_TAGS_H

namespace sc_core
{

  class sc_module;
  class sc_event;
  class sc_event_finder;
  class sc_signal_base;

  // Forward type declarations
  class scoot_channel;
  class scoot_port;

  // Scoot's TAG functions
  void scoot_start(long long);
  void scoot_module_decl(const sc_module*);
  void scoot_event_decl(const sc_event*);
  void scoot_event_sensitivity(const sc_event*);
  void scoot_event_finder_sensitivity(const sc_event_finder*);
  void scoot_channel_decl(const scoot_channel*);
  void scoot_port_decl(const scoot_port*);
  void scoot_port_to_port_binding(const scoot_port*, const scoot_port*);
  void scoot_port_to_channel_binding(const scoot_port*, const scoot_channel*);
  void scoot_create_vcd_file(const char*);
  void scoot_trace_signal(const sc_signal_base*);
  void scoot_dont_initialize();

  // Indicate a constant pointer
  void scoot_constant_pointer(const void* p);

  // Simulation time
  long long scoot_simulation_time;

  // Scoot's scheduling function
  int scoot_next_schedule(bool **, bool (**)(), bool**  , int);

  // Scoot's notification routine: returns true if a process is notified.
  bool scoot_notify_processes();

  // Scoot's runnable table
  extern bool* scoot_runnable;

  class scoot_channel
  {
    public:
      scoot_channel(){scoot_channel_decl(this);}
    private:
      // disabled
      scoot_channel(const scoot_channel&);
  };

  class scoot_port
  {
    public:
      scoot_port(){scoot_port_decl(this);}

    private:
      // disabled
      scoot_port(const scoot_port&);

  };

}

#endif
