
/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2008 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 3.0 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

//
// Note to the LRM writer : This is the core of the TLM standard
//


#ifndef __TLM_CORE_IFS_H__
#define __TLM_CORE_IFS_H__

#include <scoot_tags.h>

namespace tlm {


// uni-directional blocking interfaces

template < typename T >
class tlm_blocking_get_if
{
public:
  virtual T get() = 0;
  virtual void get( T &t ) { t = get(); }

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_blocking_put_if
{
public:
  virtual void put( const T &t ) = 0;

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

// uni-directional non blocking interfaces

template < typename T >
class tlm_nonblocking_get_if
{
public:
  virtual bool nb_get( T &t ) = 0;
  virtual bool nb_can_get() const = 0;
  virtual const sc_core::sc_event &ok_to_get() const = 0;

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_nonblocking_put_if
{
public:
  virtual bool nb_put( const T &t ) = 0;
  virtual bool nb_can_put() const = 0;
  virtual const sc_core::sc_event &ok_to_put() const = 0;

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};


// combined uni-directional blocking and non blocking 

template < typename T >
class tlm_get_if :
  public tlm_blocking_get_if< T > ,
  public tlm_nonblocking_get_if< T > 
{
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_put_if :
  public tlm_blocking_put_if< T > ,
  public tlm_nonblocking_put_if< T >
{
public:
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};


// peek interfaces

template < typename T >
class tlm_blocking_peek_if
{
public:
  virtual T peek() const = 0;
  virtual void peek( T &t ) const { t = peek(); }

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_nonblocking_peek_if
{
public:
  virtual bool nb_peek( T &t ) const = 0;
  virtual bool nb_can_peek() const = 0;
  virtual const sc_core::sc_event &ok_to_peek( ) const = 0;

  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_peek_if :
  public tlm_blocking_peek_if< T > ,
  public tlm_nonblocking_peek_if< T >
{
public:
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

// get_peek interfaces

template < typename T >
class tlm_blocking_get_peek_if :
  public tlm_blocking_get_if<T> ,
  public tlm_blocking_peek_if<T>
{
public:
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

template < typename T >
class tlm_nonblocking_get_peek_if :
  public tlm_nonblocking_get_if<T> ,
  public tlm_nonblocking_peek_if<T>
{
public:
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};


template < typename T >
class tlm_get_peek_if :
  public  tlm_blocking_get_peek_if<T> ,
  public  tlm_nonblocking_get_peek_if<T>
{
public:
  // utility function
  virtual const scoot_channel& get_channel() const = 0;
};

} // namespace tlm

#endif
